#!/bin/sh

# Copyright (c) 2018 - 2020 Jolla Ltd.
#
# License: Jolla Proprietary

ALIEN_USER=$1
ALIEN_USER_ID=$(id -u $ALIEN_USER)

rm -f /tmp/aliendalvik/generated_props
touch /tmp/aliendalvik/generated_props

echo "ro.alien.host_user_id = $(id -u $ALIEN_USER)" >> /tmp/aliendalvik/generated_props
echo "ro.alien.host_group_id = $(id -g $ALIEN_USER)" >> /tmp/aliendalvik/generated_props

echo "# hwservicemanager" >> /tmp/aliendalvik/generated_props
echo "ro.alien.hwservicemanager=1" >> /tmp/aliendalvik/generated_props

echo "# host storage" >> /tmp/aliendalvik/generated_props
echo "ro.alien.map_host_storage=true" >> /tmp/aliendalvik/generated_props

echo "# graphics" >> /tmp/aliendalvik/generated_props
echo "debug.hwui.use_buffer_age=false" >> /tmp/aliendalvik/generated_props

echo "# codecs" >> /tmp/aliendalvik/generated_props
echo "ro.vendor.extension_library=$(getprop ro.vendor.extension_library|sed 's/vendor/host_vendor/g')" >> /tmp/aliendalvik/generated_props

echo "# gralloc" >> /tmp/aliendalvik/generated_props
echo "vendor.gralloc.disable_ubwc=$(getprop vendor.gralloc.disable_ubwc)" >> /tmp/aliendalvik/generated_props

echo "# vulkan" >> /tmp/aliendalvik/generated_props
VULKAN_PROP=
for p in ro.hardware.vulkan ro.board.platform; do
    if [ "$(getprop $p)" != "" ]; then
        for l in lib lib64; do
            VULKAN_FILE_TMP=/vendor/$l/hw/vulkan.$(getprop $p).so
            VULKAN_FILE_REALPATH=$(/usr/bin/readlink -f $VULKAN_FILE_TMP)
            if [ -f "$VULKAN_FILE_REALPATH" ]; then
                VULKAN_PROP=$(echo $VULKAN_FILE_REALPATH |sed "s|.*vulkan.\(.*\).so|\1|")
                if [ "$VULKAN_PROP" != "" ]; then
                    break
                fi
            fi
        done
    fi
    if [ "$VULKAN_PROP" != "" ]; then
        break
    fi
done
if [ "$VULKAN_PROP" == "" ]; then
    VULKAN_PROP=$(getprop ro.hardware.vulkan)
fi
echo "ro.hardware.vulkan=$VULKAN_PROP" >> /tmp/aliendalvik/generated_props

echo "# camera" >> /tmp/aliendalvik/generated_props
echo "ro.alien.no_camera=0" >> /tmp/aliendalvik/generated_props

echo "# memtrack" >> /tmp/aliendalvik/generated_props
echo "ro.alien.no_memtrack=1" >> /tmp/aliendalvik/generated_props

echo "# sdcardfs" >> /tmp/aliendalvik/generated_props
echo "persist.sys.sdcardfs = force_on" >> /tmp/aliendalvik/generated_props

echo "# mobile data" >> /tmp/aliendalvik/generated_props
echo "ro.com.android.mobiledata = true" >> /tmp/aliendalvik/generated_props

echo "# lcd density" >> /tmp/aliendalvik/generated_props
dens=$(getprop ro.sf.lcd_density)
echo "ro.sf.lcd_density = $dens" >> /tmp/aliendalvik/generated_props

export XDG_CONFIG_HOME=/home/$ALIEN_USER/.config

while [ "$(dconf read /lipstick/screen/primary/width)" == "" ]; do
    echo "Waiting for screen information dconf values to be available"
    sleep 1
done

WIDTH=$(dconf read /lipstick/screen/primary/width)
HEIGHT=$(dconf read /lipstick/screen/primary/height)
DPI_X=$(dconf read /lipstick/screen/primary/physicalDotsPerInchX)
DPI_Y=$(dconf read /lipstick/screen/primary/physicalDotsPerInchY)

# physicalDotsPerInchX and physicalDotsPerInchY might not be available yet
if [ "$DPI_X" == "" ]; then
    DPI_X=$(dconf read /lipstick/screen/primary/physicalDotsPerInch)
    DPI_Y=$DPI_X
fi
export XDG_CONFIG_HOME=

echo "# alien properties." >> /tmp/aliendalvik/generated_props

# gfx
echo "ro.alien.host.display_width = $WIDTH" >> /tmp/aliendalvik/generated_props
echo "ro.alien.host.display_height = $HEIGHT" >> /tmp/aliendalvik/generated_props
echo "ro.alien.host.dpi_x = $DPI_X" >> /tmp/aliendalvik/generated_props
echo "ro.alien.host.dpi_y = $DPI_Y" >> /tmp/aliendalvik/generated_props
echo "ro.alien.host.vsync_period_ns = 16666667" >> /tmp/aliendalvik/generated_props

echo "ro.alien.no_float_pixel_format = 0" >> /tmp/aliendalvik/generated_props

# host paths
echo "ro.alien.host_storage_dir = /home/$ALIEN_USER/android_storage" >> /tmp/aliendalvik/generated_props
echo "ro.alien.host_data_dir = /home/.android" >> /tmp/aliendalvik/generated_props

# audio
echo "audio.deep_buffer.media = true" >> /tmp/aliendalvik/generated_props

# wifi
echo "wifi.interface = wlan0" >> /tmp/aliendalvik/generated_props

# networking
echo "# networking" >> /tmp/aliendalvik/generated_props
echo "ro.alien.sailfish_networking = 1" >> /tmp/aliendalvik/generated_props

# make sure the RescueParty is disabled
echo "persist.sys.enable_rescue=false" >> /tmp/aliendalvik/generated_props
echo "persist.sys.disable_rescue=true" >> /tmp/aliendalvik/generated_props

# lmkd needs this to use the in-kernel lmk interface
echo "ro.config.low_ram=false" >> /tmp/aliendalvik/generated_props

# multisim config
echo "persist.radio.multisim.config=$(getprop persist.radio.multisim.config)" >> /tmp/aliendalvik/generated_props
echo "persist.multisim.config=$(getprop persist.multisim.config)" >> /tmp/aliendalvik/generated_props

echo "# device properties" >> /tmp/aliendalvik/generated_props
echo "ro.product.name=$(getprop ro.product.name)" >> /tmp/aliendalvik/generated_props
echo "ro.product.model=$(getprop ro.product.model)" >> /tmp/aliendalvik/generated_props
echo "ro.product.device=$(getprop ro.product.device)" >> /tmp/aliendalvik/generated_props
echo "ro.product.manufacturer=$(getprop ro.product.manufacturer)" >> /tmp/aliendalvik/generated_props
echo "ro.product.brand=$(getprop ro.product.brand)" >> /tmp/aliendalvik/generated_props
echo "ro.product.board=$(getprop ro.product.board)" >> /tmp/aliendalvik/generated_props

echo "ro.opengles.version=$(getprop ro.opengles.version)" >> /tmp/aliendalvik/generated_props

echo "ro.build.product=$(getprop ro.build.product)" >> /tmp/aliendalvik/generated_props
echo "ro.build.flavor=$(getprop ro.build.flavor)" >> /tmp/aliendalvik/generated_props

echo "ro.build.description=$(getprop ro.build.description)" >> /tmp/aliendalvik/generated_props

echo "ro.board.platform=$(getprop ro.board.platform)" >> /tmp/aliendalvik/generated_props

echo "ro.vendor.product.manufacturer=$(getprop ro.vendor.product.manufacturer)" >> /tmp/aliendalvik/generated_props
echo "ro.vendor.product.model=$(getprop ro.vendor.product.model)" >> /tmp/aliendalvik/generated_props
echo "ro.vendor.product.brand=$(getprop ro.vendor.product.brand)" >> /tmp/aliendalvik/generated_props
echo "ro.vendor.product.name=$(getprop ro.vendor.product.name)" >> /tmp/aliendalvik/generated_props
echo "ro.vendor.product.device=$(getprop ro.vendor.product.device)" >> /tmp/aliendalvik/generated_props

LANG=$(grep 'LANG' /home/.system/var/lib/environment/$ALIEN_USER_ID/locale.conf | cut -d '=' -f 2) >> /tmp/aliendalvik/generated_props
LANGUAGE=$(echo $LANG | cut -d_ -f1)
COUNTRY=$(echo $LANG | cut -d_ -f2 | cut -d. -f1)
echo "persist.sys.language=$LANGUAGE" >> /tmp/aliendalvik/generated_props
echo "persist.sys.country=$COUNTRY" >> /tmp/aliendalvik/generated_props
echo "persist.sys.locale=$LANGUAGE-$COUNTRY" >> /tmp/aliendalvik/generated_props

echo "# xkb, wayland" >> /tmp/aliendalvik/generated_props
echo "ro.alien.xdg_runtime_dir=/run/" >> /tmp/aliendalvik/generated_props
echo "ro.alien.wayland_display=display/wayland-0" >> /tmp/aliendalvik/generated_props

echo "# config properties" >> /tmp/aliendalvik/generated_props

export XDG_CONFIG_HOME=/home/$ALIEN_USER/.config
for CONFKEY in $(dconf list /alien/)
do
    CONFVAL=$(dconf read /alien/$CONFKEY)
    echo "$CONFKEY=$CONFVAL" >> /tmp/aliendalvik/generated_props
done
export XDG_CONFIG_HOME=

echo "# hw adaptation extra properties" >> /tmp/aliendalvik/generated_props
echo "ro.host.battery.capacity=$(getprop ro.hybris.battery.capacity)" >> /tmp/aliendalvik/generated_props

chmod 0600 /tmp/aliendalvik/generated_props
chown root:root /tmp/aliendalvik/generated_props

