#!/bin/sh

# Copyright (c) 2018 - 2020 Jolla Ltd.
#
# License: Jolla Proprietary

ALIEN_USER=$1

IS_DEFAULT_USER=0

if [ "$ALIEN_USER" == "root" ]; then
    IS_DEFAULT_USER=1
fi

if [ "$(id -u $ALIEN_USER)" == "100000" ]; then
    IS_DEFAULT_USER=1
fi

if [ "$IS_DEFAULT_USER" == "0" ]; then
    USER_INFO_ALIEN=`lxc-attach -n aliendalvik -- /system/bin/sh -c "source /etc/mkshrc; pm list users" |grep ":$ALIEN_USER:"`
    if [ "$USER_INFO_ALIEN" == "" ]; then
        lxc-attach -n aliendalvik -- /system/bin/sh -c "source /etc/mkshrc; pm create-user $ALIEN_USER"
    fi

    USER_INFO_ALIEN=`lxc-attach -n aliendalvik -- /system/bin/sh -c "source /etc/mkshrc; pm list users" |grep ":$ALIEN_USER:"`
    USER_ID_ALIEN=`echo $USER_INFO_ALIEN |sed "s/.*UserInfo{\(.*\)}.*/\1/g" |cut -d: -f1`

    if [ "$USER_ID_ALIEN" == "" ]; then
        echo "Failed to find alien user"
        lxc-attach -n aliendalvik -- /system/bin/reboot -p
        exit 1
    else
        lxc-attach -n aliendalvik -- /system/bin/sh -c "source /etc/mkshrc; am switch-user $USER_ID_ALIEN"
    fi
else
    lxc-attach -n aliendalvik -- /system/bin/sh -c "source /etc/mkshrc; am switch-user 0"
fi

ALIEN_USERS=`lxc-attach -n aliendalvik -- /system/bin/sh -c "source /etc/mkshrc; pm list users" |grep UserInfo |sed "s/.*UserInfo{\(.*\)}.*/\1/g"`
for alien_user in $ALIEN_USERS; do
    alien_user_id=`echo $alien_user |sed "s/UserInfo{\(.*\)}/\1/g" |cut -d: -f1`
    alien_user_name=`echo $alien_user |sed "s/UserInfo{\(.*\)}/\1/g" |cut -d: -f2`
    if [ "$alien_user_id" != "0" ]; then
        if [ "$(dbus-send --system --print-reply --type=method_call --dest=org.sailfishos.usermanager / org.sailfishos.usermanager.users |grep $alien_user_name)" == "" ]; then
            echo "purging old alien user: $alien_user_name"
            lxc-attach -n aliendalvik -- /system/bin/sh -c "source /etc/mkshrc; pm remove-user $alien_user_id"
        fi
    fi
done

exit 0

