#!/bin/sh

# Copyright (c) 2018 - 2020 Jolla Ltd.
#
# License: Jolla Proprietary

ALIEN_USER=$1

if [ -e /tmp/aliendalvik/alien.user ]; then
   LAST_ALIEN_USER=$(cat /tmp/aliendalvik/alien.user)
fi

if [ "$LAST_ALIEN_USER" == "" ]; then
    LAST_ALIEN_USER=$ALIEN_USER
fi

if [ "$LAST_ALIEN_USER" != "$ALIEN_USER" ]; then
    # user switch:
    # ensure apkd connects to the correct session bus
    systemctl restart apkd
fi

echo "$ALIEN_USER" > /tmp/aliendalvik/alien.user

[ -e /usr/lib/systemd/user/alienaudio.service ] && systemctl-user start alienaudio.service
[ -e /usr/lib/systemd/user/alienkeyboard.service ] && systemctl-user start alienkeyboard.service
[ -e /usr/lib/systemd/user/apkd-bridge.service ] && systemctl-user start apkd-bridge.service
[ -e /usr/lib/systemd/user/apkd-bridge-user.service ] && systemctl-user start apkd-bridge-user.service


