#!/bin/sh

# Copyright (c) 2018 - 2020 Jolla Ltd.
#
# License: Jolla Proprietary

ALIEN_USER=$(/usr/sbin/alien-get-user.sh)

if [ "$ALIEN_USER" == "" ]; then
    ALIEN_USER=root
fi

lxc-attach -n aliendalvik -- /system/bin/reboot -p

while [ "$(lxc-info -n aliendalvik |grep RUNNING)" != "" ]; do
   echo "Waiting for container to exit."
   sleep 1
done

/usr/sbin/alien-stop-supplementary-services.sh $ALIEN_USER

exit 0

