#!/bin/sh

# Copyright (c) 2018 - 2020 Jolla Ltd.
#
# License: Jolla Proprietary

if [ "$ANDROID_DATA_ROOT" == "" ]; then
    ANDROID_DATA_ROOT=/home/.android
fi

ANDROID_DATA=$ANDROID_DATA_ROOT/data

ALIEN_USER=$(/usr/sbin/alien-get-user.sh)

if [ "$ALIEN_USER" == "" ]; then
    ALIEN_USER=root
fi

# ensure this dir exists because we need to mount it for sdcards
mkdir -p /run/media/$ALIEN_USER
chown $ALIEN_USER:$ALIEN_USER /run/media/$ALIEN_USER

# the start-aliendalvik-preinit.sh hook can create extra_config
# if it hasn't or if start-aliendalvik-preinit.sh doesn't exist
# then we need to make sure it exists.
if [ ! -f /var/lib/lxc/aliendalvik/extra_config ]; then
    touch /var/lib/lxc/aliendalvik/extra_config
fi

mkdir -p /tmp/aliendalvik

# Data storage locations
mkdir -p $ANDROID_DATA_ROOT/data/media/0

# clear cached apn database
rm -rf $ANDROID_DATA_ROOT/data/data/com.android.providers.telephony
rm -rf $ANDROID_DATA_ROOT/data/user_*/0/com.android.providers.telephony

# clear package cache for updated system apps. Remove after stop release
rm -rf $ANDROID_DATA_ROOT/data/system/package_cache/1/Settings-*

# clear cached email attachments
rm -rf $ANDROID_DATA_ROOT/data/media/0/Android/data/com.jolla.nativeapp.email/files/Documents
rm -rf /home/$ALIEN_USER/android_storage/Android/data/com.jolla.nativeapp.email/files/Documents

/usr/sbin/alien-generate-bsp-config.sh $ALIEN_USER $ANDROID_DATA_ROOT

/usr/sbin/alien-generate-properties.sh $ALIEN_USER $ANDROID_DATA_ROOT

rm -rf $ANDROID_DATA/alien_boot_completed

START_PID=$$

(

/usr/sbin/alien-wait-for-services-if-needed.sh $ALIEN_USER $ANDROID_DATA_ROOT

/usr/sbin/alien-start-supplementary-services.sh $ALIEN_USER $ANDROID_DATA_ROOT

while [ ! -f $ANDROID_DATA/alien_boot_completed ]; do sleep 1; done

/usr/sbin/alien-handle-multiple-users.sh $ALIEN_USER $ANDROID_DATA_ROOT

systemd-notify --ready
# Systemd has a bug and can't handle the situation that notifying daemon (this one)
# does exit before systemd has fully handled the notify message.
# Thus we need to stay here and make sure systemd has handled our notify message
# 60 attempts is a bit much and 5 should suffice, but let's be certain cause boot
# can be quite busy.
n=0
lxc_status=
while [ $n -lt 60 ]; do
    sleep 1
    lxc_status=`systemctl is-active aliendalvik.service`
    if [ "$lxc_status" == "active" ]; then
        break
    fi
    echo "info systemd again..."
    systemd-notify --pid=$START_PID --ready
    let n=$n+1
done

if [ "$lxc_status" == "active" ]; then
    exit 0
else
    echo "Couldn't deliver notify message to systemd"
    exit 1
fi

) &

lxc-start -n aliendalvik -F $@

# zygote crash
if [ "$(cat $ANDROID_DATA/alien_boot_completed)" == "2" ]; then
    exit 1
fi

exit 0
