#!/bin/sh

# Copyright (c) 2018 - 2020 Jolla Ltd.
#
# License: Jolla Proprietary

ALIEN_USER=$1
ANDROID_DATA_ROOT=$2

rm -f /var/lib/lxc/aliendalvik/bsp_config
touch /var/lib/lxc/aliendalvik/bsp_config

echo "lxc.mount.entry = /dev/hwpuddlejumper dev/hwbinder none bind,create=file 0 0" >> /var/lib/lxc/aliendalvik/bsp_config

# /data
echo "lxc.mount.entry = $ANDROID_DATA_ROOT/data data none remount,bind,nosuid,nodev 0 0" >> /var/lib/lxc/aliendalvik/bsp_config

# libs for graphics
echo "lxc.mount.entry = /vendor/lib/hw system/vendor/lib/hw none bind,create=dir 0 0" >> /var/lib/lxc/aliendalvik/bsp_config
echo "lxc.mount.entry = /vendor/lib64/hw system/vendor/lib64/hw none bind,create=dir,optional 0 0" >> /var/lib/lxc/aliendalvik/bsp_config

# some are in /vendor
echo "lxc.mount.entry = /vendor host_vendor none bind 0 0" >> /var/lib/lxc/aliendalvik/bsp_config

if [ "$(mount |grep odm)" == "" ]; then
    echo "lxc.mount.entry = /vendor/lib odm/lib none bind,create=dir 0 0" >> /var/lib/lxc/aliendalvik/bsp_config
    echo "lxc.mount.entry = /vendor/lib64 odm/lib64 none bind,create=dir,optional 0 0" >> /var/lib/lxc/aliendalvik/bsp_config
else
    echo "lxc.mount.entry = /odm/lib odm/lib none bind,create=dir 0 0" >> /var/lib/lxc/aliendalvik/bsp_config
    echo "lxc.mount.entry = /odm/lib64 odm/lib64 none bind,create=dir,optional 0 0" >> /var/lib/lxc/aliendalvik/bsp_config
fi

for f in /dev/video*; do
    if [ -d $f ]; then
        echo "lxc.mount.entry = $f dev/$(basename $f) none bind,create=dir 0 0" >> /var/lib/lxc/aliendalvik/bsp_config
    else
        echo "lxc.mount.entry = $f dev/$(basename $f) none bind,create=file 0 0" >> /var/lib/lxc/aliendalvik/bsp_config
    fi
done

if [ -f /system/etc/apns-conf.xml ]; then
    echo "lxc.mount.entry = /system/etc/apns-conf.xml system/etc/apns-conf.xml none bind,create=file 0 0" >> /var/lib/lxc/aliendalvik/bsp_config
fi

# wayland
echo "lxc.mount.entry = /run/display run/display none bind,create=dir 0 0" >> /var/lib/lxc/aliendalvik/bsp_config

echo "lxc.mount.entry = /home/$ALIEN_USER mnt/media_rw/8ff87de4-0b37-4799-b09a-82773e869e07 none bind,ro,create=dir 0 0" >> /var/lib/lxc/aliendalvik/bsp_config
echo "lxc.mount.entry = /run/media/$ALIEN_USER mnt/media_rw/alien_external_storage none rbind,rw,create=dir 0 0" >> /var/lib/lxc/aliendalvik/bsp_config

mkdir -p /home/$ALIEN_USER/android_storage
# android_storage
echo "lxc.mount.entry = /home/$ALIEN_USER/android_storage data/media/0 none bind,create=dir 0 0" >> /var/lib/lxc/aliendalvik/bsp_config

echo "lxc.net.0.type = none" >> /var/lib/lxc/aliendalvik/bsp_config

echo "lxc.mount.entry = /dev/kgsl-3d0 dev/kgsl-3d0 none bind,create=file,optional 0 0" >> /var/lib/lxc/aliendalvik/bsp_config
echo "lxc.mount.entry = /dev/fb0 dev/fb0 none bind,create=file,optional 0 0" >> /var/lib/lxc/aliendalvik/bsp_config
echo "lxc.mount.entry = /dev/graphics/fb0 dev/graphics/fb0 none bind,create=file,optional 0 0" >> /var/lib/lxc/aliendalvik/bsp_config
echo "lxc.mount.entry = /dev/dri dev/dri none bind,create=dir,optional 0 0" >> /var/lib/lxc/aliendalvik/bsp_config
echo "lxc.mount.entry = /dev/char dev/char none bind,create=dir,optional 0 0" >> /var/lib/lxc/aliendalvik/bsp_config

