#!/bin/sh

# Copyright (c) 2018 - 2022 Jolla Ltd.
#
# License: Jolla Proprietary

echo "# vulkan"
VULKAN_PROP=
for p in ro.hardware.vulkan ro.board.platform; do
    if [ "$(getprop $p)" != "" ]; then
        for l in lib lib64; do
            VULKAN_FILE_TMP=/vendor/$l/hw/vulkan.$(getprop $p).so
            VULKAN_FILE_REALPATH=$(/usr/bin/readlink -f $VULKAN_FILE_TMP)
            if [ -f "$VULKAN_FILE_REALPATH" ]; then
                VULKAN_PROP=$(echo $VULKAN_FILE_REALPATH |sed "s|.*vulkan.\(.*\).so|\1|")
                if [ "$VULKAN_PROP" != "" ]; then
                    break
                fi
            fi
        done
    fi
    if [ "$VULKAN_PROP" != "" ]; then
        break
    fi
done
if [ "$VULKAN_PROP" = "" ]; then
    VULKAN_PROP=$(getprop ro.hardware.vulkan)
fi
echo "ro.hardware.vulkan=$VULKAN_PROP"
