#!/bin/sh

# Copyright (c) 2021 - 2022 Jolla Ltd.
#
# License: Jolla Proprietary

PRIVILEGED=$1
OUTPUT_FILE="$2"

if [ -z "$OUTPUT_FILE" ]; then
    echo "$0 -- no output defined!" >&2
    exit 1
fi

rm -f "$OUTPUT_FILE"

USE_LXC_BRIDGE="false"

for config_file in "/etc/default/lxc-net" "/etc/sysconfig/lxc-net"; do
    if [ -f "$config_file" ]; then
        . "$config_file"
        break
    fi
done

if [ "$USE_LXC_BRIDGE" = "true" ]; then
    echo "lxc.net.0.type = veth" >> $OUTPUT_FILE
    echo "lxc.net.0.link = ${LXC_BRIDGE:-lxcbr0}" >> $OUTPUT_FILE
    echo "lxc.net.0.flags = up" >> $OUTPUT_FILE
    echo "lxc.net.0.hwaddr = 00:16:3e:xx:xx:xx" >> $OUTPUT_FILE
    echo "lxc.mount.auto = cgroup:ro sys:ro proc:mixed" >> $OUTPUT_FILE
else
    echo "lxc.net.0.type = none" >> $OUTPUT_FILE
    if [ "$PRIVILEGED" = "0" ]; then
        echo "lxc.namespace.keep = ipc net" >> $OUTPUT_FILE
    fi
    echo "lxc.mount.auto = cgroup:ro proc:mixed" >> $OUTPUT_FILE
    echo "lxc.mount.entry = /sys sys none rbind,create=dir 0 0" >> $OUTPUT_FILE
    if [ -d /sys/fs/selinux ]; then
        echo "lxc.mount.entry = tmpfs sys/fs/selinux tmpfs create=dir 0 0" >> $OUTPUT_FILE
    fi
fi

