#!/bin/sh

# Copyright (c) 2021 - 2022 Jolla Ltd.
#
# License: Jolla Proprietary

ALIEN_USER=$1
PRIVILEGED=$2
ALIEN_BASE_UID=$3
OUTPUT_FILE="$4"

if [ -z "$OUTPUT_FILE" ]; then
    echo "$0 -- no output defined!" >&2
    exit 1
fi

if [ "$PRIVILEGED" = "0" ]; then
    MAX_UIDS=200000
    ALIEN_USER_UID=$(id -u $ALIEN_USER)
    FIRST_LENGTH=$(expr $ALIEN_USER_UID - 1)
    AFTER_ALIEN_USER_UID=$(expr $ALIEN_USER_UID + 1)
    MAP_AFTER_ALIEN_USER_UID=$(expr $ALIEN_USER_UID + 1 + $ALIEN_BASE_UID)
    LAST_LENGTH=$(expr $MAX_UIDS - $ALIEN_USER_UID - 1)

    echo "lxc.seccomp.profile = /etc/aas-seccomp-profile
lxc.seccomp.allow_nesting = 1
lxc.cap.drop =
lxc.idmap = u 0 $ALIEN_BASE_UID $FIRST_LENGTH
lxc.idmap = g 0 $ALIEN_BASE_UID $FIRST_LENGTH
lxc.idmap = u $ALIEN_USER_UID $ALIEN_USER_UID 1
lxc.idmap = g $ALIEN_USER_UID $ALIEN_USER_UID 1
lxc.idmap = u $AFTER_ALIEN_USER_UID $MAP_AFTER_ALIEN_USER_UID $LAST_LENGTH
lxc.idmap = g $AFTER_ALIEN_USER_UID $MAP_AFTER_ALIEN_USER_UID $LAST_LENGTH
# WARNING: This may be overriden by the network configuration.
lxc.namespace.keep = ipc
" > $OUTPUT_FILE
fi

exit 0

