#!/bin/sh

# Copyright (c) 2018 - 2022 Jolla Ltd.
#
# License: Jolla Proprietary

INSTANCE_NAME=$1
if [ -n "$INSTANCE_NAME" ]; then
    INSTANCE_NAME="--instance $INSTANCE_NAME"
fi

appsupport-attach $INSTANCE_NAME /system/bin/sh -c "source /etc/mkshrc;
# make sure mobile data works
settings put global device_provisioned 1;
# allow automatic app rotation by default
settings put system accelerometer_rotation 1;
# fix autofill/perusersystemservices
settings put secure user_setup_complete 1;
# disable animations which break things JB#56934
settings put global transition_animation_scale 0;
# disable bluetooth packages, these don't work and are only included so more apps show up in stores.
pm disable com.android.bluetooth;
# enable memory reclaim to move unused memory to swap
device_config put activity_manager use_compaction true"
