#!/bin/sh

# Copyright (c) 2018 - 2022 Jolla Ltd.
#
# License: Jolla Proprietary

ALIEN_USER=$1
ANDROID_DATA_ROOT="$(appsupport-config --data)"
CONFIG_PATH="$(appsupport-config --path)"
CONTROL_FILE_PATH="$(appsupport-config --control)"

if [ -e $CONFIG_PATH/alien.user ]; then
   LAST_ALIEN_USER=$(cat $CONFIG_PATH/alien.user)
fi

if [ "$LAST_ALIEN_USER" = "" ]; then
    LAST_ALIEN_USER=$ALIEN_USER
fi

if [ ! -d $ANDROID_DATA_ROOT/data/aas-staging ] || [ "$(stat -c "%u" $ANDROID_DATA_ROOT/data/aas-staging)" != "0" ]; then
    # aas-staging directory has been accidentally removed, or shifted
    # by upgrade to unprivileged container, fix directories and permissions.
    mkdir -p $ANDROID_DATA_ROOT/data/aas-staging/app/packaged
    mkdir -p $ANDROID_DATA_ROOT/data/aas-staging/app/incoming
    chown root:root $ANDROID_DATA_ROOT/data/aas-staging
    chmod 755 $ANDROID_DATA_ROOT/data/aas-staging
    chown root:privileged $ANDROID_DATA_ROOT/data/aas-staging/app
    chmod 775 $ANDROID_DATA_ROOT/data/aas-staging/app
    chown $ALIEN_USER:privileged $ANDROID_DATA_ROOT/data/aas-staging/app/incoming
    chmod 775 $ANDROID_DATA_ROOT/data/aas-staging/app/incoming
    chown root:root $ANDROID_DATA_ROOT/data/aas-staging/app/packaged
    chmod 755 $ANDROID_DATA_ROOT/data/aas-staging/app/packaged
fi

if [ "$LAST_ALIEN_USER" != "$ALIEN_USER" ]; then
    # user switch:
    # ensure apkd connects to the correct session bus
    systemctl restart apkd
fi

echo "$ALIEN_USER" > $CONFIG_PATH/alien.user

if [ ! -e $CONTROL_FILE_PATH ]; then
    mkfifo -m 660 $CONTROL_FILE_PATH
fi
chown $ALIEN_USER:appsupport-root $CONTROL_FILE_PATH

(
    SERVICES="alienaudio.service alienkeyboard.service apkd-bridge.service apkd-bridge-user.service"
    CONTROL_CODE="$(cat $CONTROL_FILE_PATH)"

    if [ "$CONTROL_CODE" = "start" ]; then
        for SERVICE_NAME in $SERVICES; do
            systemctl-user start $SERVICE_NAME
        done
    else
        echo "Control code: $CONTROL_CODE"
    fi

    rm -f "$CONTROL_FILE_PATH"
) &
