#!/bin/sh

# Copyright (c) 2022 Jolla Ltd.
#
# License: Jolla Proprietary

if [ "$ANDROID_DATA_ROOT" = "" ]; then
    ANDROID_DATA_ROOT=/home/.android
fi

ANDROID_DATA=$ANDROID_DATA_ROOT/data

ALIEN_USER=$(/usr/libexec/appsupport/alien-get-user.sh)
if [ "$ALIEN_USER" = "" ]; then
    ALIEN_USER=root
fi

ALIEN_USER_ID=$(getent passwd "$ALIEN_USER" | cut -d: -f3)
ALIEN_USER_HOME=$(getent passwd "$ALIEN_USER" | cut -d: -f6)

ANDROID_EMULATED_STORAGE=$ALIEN_USER_HOME/android_storage

if [ "$ALIEN_USER" != "root" ]; then
    # Make sure host user group can always access files in emulated storage
    ALIEN_USER_GROUP=$(id -gn $ALIEN_USER)
    setfacl -R -P -d -m group:$ALIEN_USER_GROUP:rwx "$ANDROID_EMULATED_STORAGE"
    setfacl -R -P -m group:$ALIEN_USER_GROUP:rwx "$ANDROID_EMULATED_STORAGE"
fi

# This is unrelated to ALIEN_USER_ID
if [ "$(cat /opt/alien/build.prop | grep -o 'ro.alien.unprivileged=.')" = "ro.alien.unprivileged=1" ]; then
    ALIEN_BASE_UID=$(cat /opt/alien/build.prop | grep "ro.alien.unprivileged_uid=" | sed "s/.*=//g")
else
    ALIEN_BASE_UID=0
fi

MEDIA_RW_GID=$(( ALIEN_BASE_UID + 1023 ))
EXT_DATA_RW_GID=$(( ALIEN_BASE_UID + 1078 ))
EXT_OBB_RW_GID=$(( ALIEN_BASE_UID + 1079 ))

cat "$ANDROID_DATA"/system/packages.list | while read line; do
    set -- $line

    APP=$1
    APP_ID=$2
    APP_UID=$(( ALIEN_BASE_UID + APP_ID ))

    if [ "$APP" = "com.android.providers.media.module" ]; then
        MEDIA_MODULE_APP_ID=$APP_ID
        chown -R $APP_UID:$MEDIA_RW_GID "$ANDROID_EMULATED_STORAGE/Android/media"
    fi

    APP_STORAGE_DATA="$ANDROID_EMULATED_STORAGE/Android/data/$APP"
    if [ -d "$APP_STORAGE_DATA" ]; then
        chown -R $APP_UID:$EXT_DATA_RW_GID "$APP_STORAGE_DATA"
    fi

    APP_STORAGE_OBB="$ANDROID_EMULATED_STORAGE/Android/obb/$APP"
    if [ -d "$APP_STORAGE_OBB" ]; then
        chown -R $APP_UID:$EXT_OBB_RW_GID "$APP_STORAGE_OBB"
    fi
done
