#!/bin/sh

# Copyright (c) 2018 - 2022 Jolla Ltd.
#
# License: Jolla Proprietary

INSTANCE_NAME=$1
if [ -n "$INSTANCE_NAME" ]; then
    CONFIG_INSTANCE="--instance $INSTANCE_NAME"
fi

CONTAINER_NAME="$(appsupport-config $CONFIG_INSTANCE --name)"
CONTAINER_CONFIG_PATH="$(appsupport-config $CONFIG_INSTANCE --path)"
CONTAINER_CONFIG_AGGREGATE_FILE="$(appsupport-config $CONFIG_INSTANCE --config)"
ANDROID_DATA_ROOT="$(appsupport-config --data)"

if systemctl is-active $CONTAINER_NAME 1>/dev/null; then
    # Container already running, no need to prepare anything.
    exit 0
fi

ANDROID_DATA=$ANDROID_DATA_ROOT/data

ALIEN_USER=$(/usr/libexec/appsupport/alien-get-user.sh)

if [ "$ALIEN_USER" = "" ]; then
    ALIEN_USER=root
fi

# This is unrelated to ALIEN_USER_ID
if [ "$(cat /opt/alien/build.prop | grep -o 'ro.alien.unprivileged=.')" = "ro.alien.unprivileged=1" ]; then
    PRIVILEGED=0
    ALIEN_BASE_UID=$(cat /opt/alien/build.prop | grep "ro.alien.unprivileged_uid=" | sed "s/.*=//g")
else
    PRIVILEGED=1
    ALIEN_BASE_UID=0
fi

ALIEN_USER_ID=$(getent passwd $ALIEN_USER | cut -d: -f3)
ALIEN_USER_HOME=$(getent passwd $ALIEN_USER | cut -d: -f6)

# ensure this dir exists because we need to mount it for sdcards
mkdir -p /run/media/$ALIEN_USER
chown $ALIEN_USER:$ALIEN_USER /run/media/$ALIEN_USER

if [ -d $CONTAINER_CONFIG_PATH ]; then
    rm -r $CONTAINER_CONFIG_PATH
fi
mkdir -p $CONTAINER_CONFIG_PATH

# Data storage locations
mkdir -p $ANDROID_DATA_ROOT/data/media/0
chown $ALIEN_BASE_UID:$ALIEN_BASE_UID $ANDROID_DATA_ROOT

do_shift_uids() {
    local SHIFT_DIRECTORY="$1"
    local SHIFT_DIRECTION="$2"
    local SHIFT_UID="$3"
    local TMP_FILES="/tmp/appsupport_shift_uids.$$.$RANDOM"

    find $SHIFT_DIRECTORY \! -type l -mindepth 1 -not -path "*/.android/data/aas-staging*" > $TMP_FILES
    if [ $? -ne 0 ]; then
        echo "Failed to shift $SHIFT_DIRECTION $SHIFT_DIRECTORY files (find failed)." >&2
        exit 1
    fi

    /usr/libexec/appsupport/shift_ids $SHIFT_DIRECTION $SHIFT_UID < $TMP_FILES
    if [ $? -ne 0 ]; then
        echo "Failed to shift $SHIFT_DIRECTION $SHIFT_DIRECTORY files (shift_uids failed)." >&2
        exit 1
    fi

    if [ "$SHIFT_DIRECTION" = "up" ]; then
        echo -n "$SHIFT_UID" > "$SHIFT_DIRECTORY/.privilege_migration_done"
    else
        rm -f "$SHIFT_DIRECTORY/.privilege_migration_done"
    fi

    rm -f $TMP_FILES
}

if [ "$PRIVILEGED" = "1" ]; then
    if [ -f "$ANDROID_DATA_ROOT/.privilege_migration_done" ]; then
        ALIEN_FILES_BASE_UID=$(cat "$ANDROID_DATA_ROOT/.privilege_migration_done")
        do_shift_uids $ANDROID_DATA_ROOT down $ALIEN_FILES_BASE_UID
    fi
    if [ -f "$ALIEN_USER_HOME/android_storage/.privilege_migration_done" ]; then
        ALIEN_FILES_BASE_UID=$(cat "$ALIEN_USER_HOME/android_storage/.privilege_migration_done")
        do_shift_uids $ALIEN_USER_HOME/android_storage down $ALIEN_FILES_BASE_UID
    fi
elif [ "$PRIVILEGED" = "0" ]; then
    if [ -d "$ANDROID_DATA_ROOT" ] &&
       [ ! -f "$ANDROID_DATA_ROOT/.privilege_migration_done" ]; then
        do_shift_uids $ANDROID_DATA_ROOT up $ALIEN_BASE_UID
    fi
    if [ -d "$ALIEN_USER_HOME/android_storage" ] &&
       [ ! -f "$ALIEN_USER_HOME/android_storage/.privilege_migration_done" ]; then
        do_shift_uids $ALIEN_USER_HOME/android_storage up $ALIEN_BASE_UID
    fi
fi

if grep -q "ro.build.version.sdk=30" /opt/alien/build.prop; then
    MIGRATION_SCRIPT=/usr/libexec/appsupport/appsupport-storage-migration.sh
    if [ -f "$MIGRATION_SCRIPT" ] && [ -d "$ALIEN_USER_HOME/android_storage" ] && \
        ([ ! -f "$ALIEN_USER_HOME/android_storage/.storage_migration_done" ] || \
            [ "$ALIEN_USER_HOME/android_storage/.storage_migration_done" -ot "$MIGRATION_SCRIPT" ]); then
        # Make sure subfolders in android_storage/Android/{data,media,obb} are owned by the apps
        "$MIGRATION_SCRIPT"
        touch "$ALIEN_USER_HOME/android_storage/.storage_migration_done"
    fi
fi

# clear cached apn database
rm -rf $ANDROID_DATA_ROOT/data/data/com.android.providers.telephony
rm -rf $ANDROID_DATA_ROOT/data/user_de/0/com.android.providers.telephony

# clear cached email attachments
rm -rf $ANDROID_DATA_ROOT/data/media/0/Android/data/com.jolla.nativeapp.email/files/Documents
rm -rf $ALIEN_USER_HOME/android_storage/Android/data/com.jolla.nativeapp.email/files/Documents

/usr/libexec/appsupport/alien-generate-rootfs-config.sh "$CONTAINER_CONFIG_PATH/40-rootfs_config"

/usr/libexec/appsupport/appsupport-generate-config --type lxc --user-id "$ALIEN_USER_ID" --instance "$INSTANCE_NAME" --base-uid "$ALIEN_BASE_UID" "$CONTAINER_CONFIG_PATH/10-bsp_config" || exit 32

/usr/libexec/appsupport/alien-generate-net-config.sh $PRIVILEGED "$CONTAINER_CONFIG_PATH/30-net_config"

/usr/libexec/appsupport/appsupport-generate-config --type property --user-id "$ALIEN_USER_ID" --instance "$INSTANCE_NAME" --base-uid "$ALIEN_BASE_UID" "$CONTAINER_CONFIG_PATH/generated_props" || exit 32

/usr/libexec/appsupport/alien-generate-privilege-config.sh $ALIEN_USER $PRIVILEGED $ALIEN_BASE_UID "$CONTAINER_CONFIG_PATH/20-privilege_config"

if [ -f /usr/libexec/appsupport/alien-generate-extra-config.sh ]; then
    /usr/libexec/appsupport/alien-generate-extra-config.sh $INSTANCE_NAME $CONTAINER_CONFIG_PATH
fi

# This needs to be after all the config generation scripts have run
for CONFIG_FILE in $(ls -1 $CONTAINER_CONFIG_PATH/*_config | sort); do
    echo "lxc.include = $CONFIG_FILE" >> $CONTAINER_CONFIG_AGGREGATE_FILE
done

chown -R $ALIEN_BASE_UID:$ALIEN_BASE_UID $CONTAINER_CONFIG_PATH

/usr/libexec/appsupport/alien-start-supplementary-services.sh $ALIEN_USER $ANDROID_DATA_ROOT $INSTANCE_NAME

exit 0

