#!/bin/sh

# Copyright (c) 2018 - 2022 Jolla Ltd.
#
# License: Jolla Proprietary

INSTANCE_NAME=$1
if [ -n "$INSTANCE_NAME" ]; then
    CONFIG_INSTANCE="--instance $INSTANCE_NAME"
fi

CONTAINER_NAME="$(appsupport-config $CONFIG_INSTANCE --name)"
CONTAINER_CONFIG_FILE="$(appsupport-config $CONFIG_INSTANCE --config)"
LXC_CONFIG_PATH="$(appsupport-config --lxc-path)"

if [ "$CONTAINER_SERVICE" = "" ]; then
    CONTAINER_SERVICE=aliendalvik.service
fi

ANDROID_DATA_ROOT="$(appsupport-config --data)"

ANDROID_DATA=$ANDROID_DATA_ROOT/data

ALIEN_USER=$(/usr/libexec/appsupport/alien-get-user.sh)

if [ "$ALIEN_USER" = "" ]; then
    ALIEN_USER=root
fi

# This is unrelated to ALIEN_USER_ID
if [ "$(cat /opt/alien/build.prop | grep -o 'ro.alien.unprivileged=.')" = "ro.alien.unprivileged=1" ]; then
    PRIVILEGED=0
    ALIEN_BASE_UID=$(cat /opt/alien/build.prop | grep "ro.alien.unprivileged_uid=" | sed "s/.*=//g")
else
    PRIVILEGED=1
    ALIEN_BASE_UID=0
fi

ALIEN_USER_ID=$(getent passwd $ALIEN_USER | cut -d: -f3)
ALIEN_USER_HOME=$(getent passwd $ALIEN_USER | cut -d: -f6)

rm -rf $ANDROID_DATA/alien_boot_completed

START_PID=$$

(

/usr/libexec/appsupport/alien-wait-for-services-if-needed.sh $LXC_CONFIG_PATH $ANDROID_DATA_ROOT $INSTANCE_NAME

while [ ! -f $ANDROID_DATA/alien_boot_completed ]; do sleep 1; done

systemd-notify --ready
# Systemd has a bug and can't handle the situation that notifying daemon (this one)
# does exit before systemd has fully handled the notify message.
# Thus we need to stay here and make sure systemd has handled our notify message
# 60 attempts is a bit much and 5 should suffice, but let's be certain cause boot
# can be quite busy.
n=0
lxc_status=
while [ $n -lt 60 ]; do
    sleep 1
    lxc_status=`systemctl is-active $CONTAINER_SERVICE`
    if [ "$lxc_status" = "active" ]; then
        break
    fi
    echo "info systemd again..."
    systemd-notify --pid=$START_PID --ready
    let n=$n+1
done

if [ "$lxc_status" = "active" ]; then
    exit 0
else
    echo "Couldn't deliver notify message to systemd"
    exit 1
fi

) &

lxc-start --rcfile=$CONTAINER_CONFIG_FILE --lxcpath=$LXC_CONFIG_PATH -n $CONTAINER_NAME -F

# zygote crash
if [ "$(cat $ANDROID_DATA/alien_boot_completed)" = "2" ]; then
    exit 1
fi

exit 0

