#!/bin/sh

# Copyright (c) 2018 - 2022 Jolla Ltd.
#
# License: Jolla Proprietary

INSTANCE_NAME=$1
if [ -n "$INSTANCE_NAME" ]; then
    INSTANCE_NAME="--instance $INSTANCE_NAME"
fi

if [ ! -f "$(appsupport-config --config $INSTANCE_NAME)" ]; then
    echo "No container found: $INSTANCE_NAME"
    exit 1
fi

appsupport-attach $INSTANCE_NAME /system/bin/reboot -p

CONTROL_FILE="$(appsupport-config --control $INSTANCE_NAME)"
if [ -e "$CONTROL_FILE" ]; then
    echo stop > "$CONTROL_FILE" &
fi

while appsupport-info $INSTANCE_NAME --running; do
   echo "Waiting for container to exit."
   sleep 1
done

exit 0

