#!/bin/sh
# setup binder device nodes for devices with binderfs
#
# Copyright (c) 2021 - 2022 Jolla Ltd.
#
# License: Jolla Proprietary

# check if binderfs is supported by kernel
if grep -q binder /proc/filesystems; then
    if [ ! -e "/dev/binderfs" ]; then
        mkdir -p /dev/binderfs
        mount -t binder binder /dev/binderfs
    fi

    if [ -e "/dev/binderfs" ] && which binder-add 1>/dev/null; then
        for devicenode in puddlejumper hwpuddlejumper vndpuddlejumper; do
            if [ ! -e "/dev/binderfs/$devicenode" ]; then
                binder-add $devicenode
            fi
            if [ ! -e "/dev/$devicenode" ]; then
                ln -s "/dev/binderfs/$devicenode" "/dev/$devicenode"
            fi
            chmod 666 "/dev/binderfs/$devicenode"
        done
    fi
fi
