#!/bin/bash

APPSUPPORT_OVERLAY_CACHE=/var/lib/appsupport_overlay/cache
APPSUPPORT_OVERLAY_CONFIG=/var/lib/appsupport_overlay/overlay_config
APPSUPPORT_OVERLAY_TAR="appsupport_overlay.tar.gz"
APPSUPPORT_OVERLAY_TAR_LOOKUP="/opt/appsupport_overlay/$APPSUPPORT_OVERLAY_TAR
                              /home/appsupport_overlay/$APPSUPPORT_OVERLAY_TAR
                              /home/$APPSUPPORT_OVERLAY_TAR
                              /home/.$APPSUPPORT_OVERLAY_TAR
                              /home/defaultuser/$APPSUPPORT_OVERLAY_TAR
                              /home/defaultuser/.$APPSUPPORT_OVERLAY_TAR"

OVERLAY_TAR=
OVERLAY_PATH=
OVERLAY_TAR_ACCESS=
SYSTEM_IMG_ACCESS=

SYSTEM_IMG_CHANGED=0
OVERLAY_TAR_CHANGED=0
APPSUPPORT_WAS_RUNNING=0
FORCE_INSTALL=0
UNINSTALL=0

SYSTEM_IMG_MOUNTED=0
SYSTEM_IMG_MOUNT=/tmp/tmp_appsupport_mount.$$

if [ "$(whoami)" != "root" ]; then
    echo "This script needs to be run by root."
    exit 1
fi

if [ -e "/var/lib/lxc/aliendalvik/rootfs_config" ]; then
    LXC_CONFIG_FILE="/var/lib/lxc/aliendalvik/rootfs_config"
    LEGACY_EXTRA_CONFIG="/var/lib/lxc/aliendalvik/extra_config"
elif [ -e "/var/lib/lxc/aliendalvik/config" ]; then
    LXC_CONFIG_FILE="/var/lib/lxc/aliendalvik/config"
    LEGACY_EXTRA_CONFIG="/var/lib/lxc/aliendalvik/extra_config"
elif [ -f "/opt/alien/system.img" ]; then
    SYSTEM_IMG="/opt/alien/system.img"
fi

if [ -n "$LEGACY_EXTRA_CONFIG" ]; then
    SYSTEM_IMG=$(cat $LXC_CONFIG_FILE 2>/dev/null | grep lxc.rootfs.path | sed "s/.*loop://g")
fi

BUILD_PROP="/opt/alien/build.prop"

if [ -z "$SYSTEM_IMG" ]; then
    echo "Could not determine system image path!!!"
    exit 1
fi

read_build_prop() {
    grep "${1}=" "$BUILD_PROP" | cut -d= -f2
}

UNPRIVILEGED_CONTAINER=$(read_build_prop ro.alien.unprivileged)

if [ "$1" == "force" ]; then
    FORCE_INSTALL=1
elif [ "$1" == "uninstall" ]; then
    UNINSTALL=1
fi

if systemctl is-active aliendalvik > /dev/null; then
    APPSUPPORT_WAS_RUNNING=1
fi

# Check for already installed overlay
if [ -f "$APPSUPPORT_OVERLAY_CACHE" ]; then
    source "$APPSUPPORT_OVERLAY_CACHE"

    if [ -z "$SYSTEM_IMG_ACCESS" ] || [ -z "$OVERLAY_TAR_ACCESS" ] || [ -z "$OVERLAY_TAR" ] || [ -z "$OVERLAY_PATH" ]; then
        # Bad cache file
        SYSTEM_IMG_CHANGED=1
        OVERLAY_TAR_CHANGED=1
        OVERLAY_PATH=
        OVERLAY_TAR=
        SYSTEM_IMG_ACCESS=
        OVERLAY_TAR_ACCESS=
    else
        if [ "$SYSTEM_IMG_ACCESS" != "$(stat -c '%Y' $SYSTEM_IMG)" ]; then
            SYSTEM_IMG_CHANGED=1
        fi

        if [ ! -f "$OVERLAY_TAR" ]; then
            OVERLAY_TAR=
            OVERLAY_TAR_CHANGED=1
        elif [ "$OVERLAY_TAR_ACCESS" != "$(stat -c '%Y' "$OVERLAY_TAR")" ]; then
            OVERLAY_TAR_CHANGED=1
        fi
    fi

    if [ $SYSTEM_IMG_CHANGED -eq 1 ] || [ $OVERLAY_TAR_CHANGED -eq 1 ] || [ $FORCE_INSTALL -eq 1 ]; then
        if [ $APPSUPPORT_WAS_RUNNING -eq 1 ]; then
            systemctl stop aliendalvik
        fi
        if [ -d "$OVERLAY_PATH" ]; then
            rm -rf "$OVERLAY_PATH"
        fi
        if [ ! -f "$OVERLAY_TAR" ]; then
            OVERLAY_TAR=
        fi
        OVERLAY_TAR_ACCESS=
        SYSTEM_IMG_ACCESS=
        rm -f "$APPSUPPORT_OVERLAY_CACHE"
        rm -f "$APPSUPPORT_OVERLAY_CONFIG"
        if [ -n "$LEGACY_EXTRA_CONFIG" ]; then
            echo "# appsupport overlay, do not edit, this file is autogenerated." > $LEGACY_EXTRA_CONFIG
        fi
    else
        # Overlay ok
        if [ $UNINSTALL -eq 1 ]; then
            if [ $APPSUPPORT_WAS_RUNNING -eq 1 ]; then
                systemctl stop aliendalvik
            fi

            if [ -d "$OVERLAY_PATH" ]; then
                rm -rf "$OVERLAY_PATH"
            fi
            rm -f "$APPSUPPORT_OVERLAY_CACHE"
            rm -f "$APPSUPPORT_OVERLAY_CONFIG"
            if [ -n "$LEGACY_EXTRA_CONFIG" ]; then
                echo -n "" > $LEGACY_EXTRA_CONFIG
            fi

            if [ $APPSUPPORT_WAS_RUNNING -eq 1 ]; then
                systemctl restart aliendalvik
            fi
        fi
        exit 0
    fi
fi

if [ -z "$OVERLAY_TAR" ]; then
    # Generic locations
    for LOOKUP in $APPSUPPORT_OVERLAY_TAR_LOOKUP; do
        if [ -f "$LOOKUP" ]; then
            OVERLAY_TAR="$LOOKUP"
            OVERLAY_PATH="$(dirname $OVERLAY_TAR)/.appsupport_overlay"
            break
        fi
    done
fi

if [ -z "$OVERLAY_TAR" ]; then
    # No overlay tar.
    exit 0
fi

overlay_done_exit() {
    if [ $SYSTEM_IMG_MOUNTED -eq 1 ]; then
        umount "$SYSTEM_IMG_MOUNT"
    fi
    if [ -d "$SYSTEM_IMG_MOUNT" ]; then
        rmdir "$SYSTEM_IMG_MOUNT"
    fi
}

trap overlay_done_exit EXIT

mkdir $SYSTEM_IMG_MOUNT
if [ $? -ne 0 ]; then
    echo "Failed to create location for system image mount $SYSTEM_IMG_MOUNT"
    exit 1
fi

mount $SYSTEM_IMG $SYSTEM_IMG_MOUNT
if [ $? -eq 0 ]; then
    SYSTEM_IMG_MOUNTED=1
else
    echo "Failed to mount $SYSTEM_IMG to $SYSTEM_IMG_MOUNT"
    exit 1
fi

mkdir -p $OVERLAY_PATH
mkdir -p $(dirname $APPSUPPORT_OVERLAY_CACHE)
echo "# appsupport overlay, do not edit, this file is autogenerated." > $APPSUPPORT_OVERLAY_CONFIG

for OVERLAY_PART in $(gunzip -c "$OVERLAY_TAR" | tar --list | cut -d'/' -f-2 | sort | uniq); do
    if [ "$(echo $OVERLAY_PART | cut -d'/' -f2)" == "" ]; then
        mkdir -p "$OVERLAY_PATH/$OVERLAY_PART"
        ORIG_OWNERSHIP=$(stat -c "%u:%g" "$SYSTEM_IMG_MOUNT/$OVERLAY_PART")
        ORIG_PERMISSIONS=$(stat -c "%a" "$SYSTEM_IMG_MOUNT/$OVERLAY_PART")
        chown $ORIG_OWNERSHIP "$OVERLAY_PATH/$OVERLAY_PART"
        chmod $ORIG_PERMISSIONS "$OVERLAY_PATH/$OVERLAY_PART"
        continue
    fi

    if [ "$OVERLAY_PART" == "init.sh" ]; then
        continue
    fi

    cp -a $SYSTEM_IMG_MOUNT/$OVERLAY_PART $OVERLAY_PATH/$OVERLAY_PART

    echo "lxc.mount.entry = $OVERLAY_PATH/$OVERLAY_PART $OVERLAY_PART none rbind,ro 0 0" >> $APPSUPPORT_OVERLAY_CONFIG
done

tar oxzf $OVERLAY_TAR -C $OVERLAY_PATH

if [ "$UNPRIVILEGED_CONTAINER" == "1" ]; then
    ANDROID_BASE_UID=$(read_build_prop ro.alien.unprivileged_uid)
    TMP_FILES="/tmp/appsupport_overlay.$$.$RANDOM"

    find "$OVERLAY_PATH" \! -type l -mindepth 1 > $TMP_FILES
    if [ $? -ne 0 ]; then
        echo "Appsupport overlay: Shifting $OVERLAY_PATH files up failed (find failed)." >&2
        rm -rf "$OVERLAY_PATH"
        exit 1
    fi

    /usr/libexec/appsupport/shift_ids up $ANDROID_BASE_UID < $TMP_FILES
    if [ $? -ne 0 ]; then
        echo "Appsupport overlay: Shifting $OVERLAY_PATH files up failed (shift_ids failed)." >&2
        rm -rf "$OVERLAY_PATH"
        exit 1
    fi

    rm -f $TMP_FILES
fi

if [ -f "$OVERLAY_PATH/init.sh" ]; then
    OVERLAY_CONFIG=$APPSUPPORT_OVERLAY_CONFIG OVERLAY_PATH=$OVERLAY_PATH SYSTEM_IMG_MOUNT=$SYSTEM_IMG_MOUNT bash "$OVERLAY_PATH/init.sh"
fi

cat << EOF >$APPSUPPORT_OVERLAY_CACHE
SYSTEM_IMG_ACCESS=$(stat -c "%Y" $SYSTEM_IMG)
OVERLAY_TAR_ACCESS=$(stat -c "%Y" $OVERLAY_TAR)
OVERLAY_TAR=$OVERLAY_TAR
OVERLAY_PATH=$OVERLAY_PATH
EOF

if [ -n "$LEGACY_EXTRA_CONFIG" ]; then
    echo "lxc.include = $APPSUPPORT_OVERLAY_CONFIG" > "$LEGACY_EXTRA_CONFIG"
fi

if [ $APPSUPPORT_WAS_RUNNING -eq 1 ]; then
    systemctl restart aliendalvik
fi
