#!/bin/sh

# Copyright (c) 2018 - 2024 Jolla Ltd.
# Copyright (c) 2024 Seafarix Ltd.

mount_path() {
    IMAGE_PATH="$1"
    MOUNT_PATH="$2"

    mount -o loop "$IMAGE_PATH" "$MOUNT_PATH" 2>/dev/null

    if [ $? -ne 0 ]; then
        exit 32
    fi
}

umount_path() {
    MOUNT_PATH="$1"

    if [ -d "$MOUNT_PATH" ]; then
        umount "$MOUNT_PATH" 2>/dev/null || :
    fi
}

if [ -z "$EXT_PRODUCT_MOUNTED" ] || [ "$EXT_PRODUCT_MOUNTED" = "0" ]; then
    umount_path "$ROOTFS_PATH/product"
fi

if [ -z "$EXT_ROOTFS_MOUNTED" ] || [ "$EXT_ROOTFS_MOUNTED" = "0" ]; then
    umount_path "$ROOTFS_PATH"
    mkdir -p "$ROOTFS_PATH" 2>/dev/null
    mount_path "$SYSTEM_IMAGE_PATH" "$ROOTFS_PATH"
fi

if [ -z "$EXT_PRODUCT_MOUNTED" ] || [ "$EXT_PRODUCT_MOUNTED" = "0" ]; then
    if [ -f "$PRODUCT_IMAGE_PATH" ]; then
        mount_path "$PRODUCT_IMAGE_PATH" "$ROOTFS_PATH/product"
    fi
fi

exit 0
