#!/bin/sh

# Copyright (c) 2023 Jolla Ltd.
#
# License: Jolla Proprietary

LOGGER_ENABLED="$($APPSUPPORT_PARSE_CONFIG --key LogcatLogEnabled)"
ANR_ENABLED="$($APPSUPPORT_PARSE_CONFIG --key AnrEnabled)"

if [ "$LOGGER_ENABLED" = "true" ]; then
    systemctl start appsupport-logger@${INSTANCE_NAME}.service
fi

if [ "$ANR_ENABLED" = "true" ]; then
    systemctl start appsupport-anr@${INSTANCE_NAME}.service
fi

if [ "$LOGGER_ENABLED" = "true" ] || [ "$ANR_ENABLED" = "true" ]; then
    . "$APPSUPPORT_API"
    appsupport_init_export LOGGER_ENABLED=$LOGGER_ENABLED
    appsupport_init_export ANR_ENABLED=$ANR_ENABLED
fi
