#!/bin/sh
# Copyright (c) 2023 Jolla Ltd.
#
# License: Jolla Proprietary

SERVICES="$($APPSUPPORT_PARSE_CONFIG --key SupplementaryServices --list --list-separator ' ')"
DBUS_ADDR=

with_user_session() {
    if [ -z "$DBUS_ADDR" ]; then
        DBUS_ADDR="$($APPSUPPORT_PARSE_CONFIG --key DBusSessionBusAddress)"
        if [ -z "$DBUS_ADDR" ]; then
            >&2 echo "DBusSessionBusAddress required but not set."
            exit 1
        fi
    fi

    if which capsh >/dev/null; then
        ARGS="$@"
        capsh --user=$APPSUPPORT_USER -+ -c "env DBUS_SESSION_BUS_ADDRESS=\"$DBUS_ADDR\" systemctl --user $ARGS"
        return $?
    else
        (
            export DBUS_SESSION_BUS_ADDRESS="$DBUS_ADDR"
            export USER="$APPSUPPORT_USER"
            export HOME="$APPSUPPORT_USER_HOME"
            systemctl --user "$@" 2>/dev/null
            # We exit from the subshell
            exit $?
        )
        return $?
    fi
}

check_unit() {
    SESSION="$1"
    UNIT="$2"
    RESULT=
    if [ "$SESSION" = "user" ]; then
        if [ "$(whoami)" = "$APPSUPPORT_USER" ]; then
            RESULT=$(systemctl --user is-enabled "$UNIT" 2> /dev/null)
        else
            RESULT="$(with_user_session is-enabled "$UNIT")"
        fi
    else
        RESULT=$(systemctl is-enabled "$UNIT" 2> /dev/null)
    fi
    [ $? -eq 0 ] && [ "$RESULT" != "masked" ]
}

for SERVICE in $SERVICES; do
    if check_unit "user" "$SERVICE"; then
        echo "Start --user $SERVICE"
        if [ "$(whoami)" = "$APPSUPPORT_USER" ]; then
            systemctl --user start "$SERVICE"
        else
            with_user_session start "$SERVICE"
        fi
    elif check_unit "system" "$SERVICE"; then
        echo "Start $SERVICE"
        systemctl start "$SERVICE"
    else
        >&2 echo "No such systemd service $SERVICE"
        exit 1
    fi
done

exit 0
