/****************************************************************************************
**
** Copyright (c) 2021 Jolla Ltd.
** Copyright (c) 2024 Seafarix Ltd.
** All rights reserved.
**
** License: Proprietary.
**
****************************************************************************************/
import QtQuick 2.6
import Sailfish.Silica 1.0
import Nemo.DBus 2.0

Item {
    property var shareAction

    Component.onCompleted: {
        var action = "android.intent.action.SEND"
        var title = ""
        var extras = {}
        if (shareAction.resources.length == 1) {
            if (shareAction.mimeType.indexOf("text/") == 0) {
                // Android doesn't understand text/x-url
                if (shareAction.mimeType == "text/x-url") shareAction.mimeType = "text/plain"
                // Set SUBJECT from name or linkTitle
                if (shareAction.resources[0]["name"]) {
                    extras["android.intent.extra.SUBJECT"] = shareAction.resources[0]["name"].toString();
                } else if (shareAction.resources[0]["linkTitle"]) {
                    extras["android.intent.extra.SUBJECT"] = shareAction.resources[0]["linkTitle"].toString();
                }
                // Set TEXT from data or status
                if (shareAction.resources[0]["data"]) {
                    extras["android.intent.extra.TEXT"] = shareAction.resources[0]["data"].toString();
                } else if (shareAction.resources[0]["status"]) {
                    extras["android.intent.extra.TEXT"] = shareAction.resources[0]["status"].toString();
                }
            } else {
                extras["android.intent.extra.STREAM"] = shareAction.resources[0].toString()
            }
/* Multiple items doesn't work yet
 * Apkd needs to be able to unpack a list of strings in an extra and convert them to QUrls
        } else if (shareAction.resources.length > 1) {
            action = "android.intent.action.SEND_MULTIPLE"
            var streams = {}
            for (var url in resources)
                streams.push(url.toString());
            extras["android.intent.extra.STREAM"] = streams
        }
        if (shareAction.resources.length > 0) {
*/
            var component = shareAction.selectedTransferMethodInfo["methodId"].split("/")
            apkd.call("launchIntent", [ action, "", shareAction.mimeType, component[0], component[1], "android.intent.category.DEFAULT", extras ])
        }
        shareAction.done()
    }

    DBusInterface {
        id: apkd
        bus: DBus.SessionBus
        service: "com.jolla.apkd"
        path: "/com/jolla/apkd"
        iface: "com.jolla.apkd"
    }
}
