#!/bin/sh

LEGACY_DATA_ROOT="/home/.android"
APPSUPPORT_DATA_ROOT="/home/.appsupport"
APPSUPPORT_DATA_INSTANCE="$APPSUPPORT_DATA_ROOT/instance"
USERNAME="$(getent passwd 100000 | cut -d':' -f1)"
ANDROID_DATA_ROOT="$APPSUPPORT_DATA_INSTANCE/$USERNAME"
LEGACY_PACKAGED="$LEGACY_DATA_ROOT/data/aas-staging/app/packaged"
COMMON_PACKAGED="$APPSUPPORT_DATA_ROOT/packaged"
PACKAGED_SYMLINK="/data/app/packaged"

if [ "$1" = "setup" ]; then
    # If previous data path exists and there are apks move
    # them to correct locations

    if [ ! -d "$COMMON_PACKAGED" ]; then
        mkdir -p "$COMMON_PACKAGED"
        chmod o+rx "$APPSUPPORT_DATA_ROOT"
    fi

    if [ -d "$LEGACY_PACKAGED" ]; then
        if [ "$(ls -A "$LEGACY_PACKAGED")" != "" ]; then
            mv $LEGACY_PACKAGED/* "$COMMON_PACKAGED"
        fi
        rmdir "$LEGACY_PACKAGED"
    fi

    if [ -L "/data/app" ]; then
        rm "/data/app"
    fi

    if [ ! -d "/data/app" ]; then
        mkdir "/data/app"
    fi

    # If something got installed to /data/app/packaged before the symlink
    # to /home/.appsupport/packaged was made, move the files to proper location
    if [ ! -L "$PACKAGED_SYMLINK" ] && [ -d "$PACKAGED_SYMLINK" ]; then
        if [ "$(ls -A "$PACKAGED_SYMLINK")" != "" ]; then
            mv $PACKAGED_SYMLINK/* "$COMMON_PACKAGED"
        fi
        rmdir "$PACKAGED_SYMLINK"
    fi

    if [ ! -L "$PACKAGED_SYMLINK" ]; then
        ln -sf "$COMMON_PACKAGED" "$PACKAGED_SYMLINK"
    fi
fi

if [ "$1" = "migrate" ]; then
    AUTOSTART=1
    if [ "$2" = "--autostart-disabled" ]; then
        AUTOSTART=0
    fi

    if [ ! -d "$ANDROID_DATA_ROOT" ] && [ -d "$LEGACY_DATA_ROOT" ]; then
        # 1. create /home/.appsupport/instance
        # 2. set permissions
        # 3. move data root to /home/.appsupport/instance/<INSTANCE>
        mkdir -p "$APPSUPPORT_DATA_INSTANCE"
        if [ $? -ne 0 ]; then
            echo "Failed to create $APPSUPPORT_DATA_INSTANCE"
            exit 1
        fi
        chmod o+rx "$APPSUPPORT_DATA_INSTANCE"
        if [ $? -ne 0 ]; then
            echo "Failed to set permissions for $APPSUPPORT_DATA_INSTANCE"
            exit 1
        fi
        mv "$LEGACY_DATA_ROOT" "$ANDROID_DATA_ROOT"
        if [ $? -ne 0 ]; then
            echo "Failed to migrate to new $ANDROID_DATA_ROOT"
            exit 1
        fi
        chown $USERNAME "$ANDROID_DATA_ROOT"
        if [ $AUTOSTART -eq 0 ]; then
            touch "$ANDROID_DATA_ROOT/autostart_disabled"
            chown $USERNAME "$ANDROID_DATA_ROOT/autostart_disabled"
        fi
        echo "Migrated $LEGACY_DATA_ROOT to $ANDROID_DATA_ROOT"
    fi
fi
